/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MinecraftServer
implements ad,
Runnable,
mx {
    private static MinecraftServer l;
    private final amf m;
    private final mv n = new mv("server", this, MinecraftServer.aq());
    private final File o;
    private final List playersOnline = new ArrayList();
    private final List p = new ArrayList();
    private final ac q;
    public final lv a = new lv();
    private String r;
    private int s = -1;
    public js[] b;
    private hn t;
    private boolean u = true;
    private boolean v;
    protected int w;
    protected Proxy c = Proxy.NO_PROXY;
    public String d;
    public int e;
    private boolean x;
    private boolean y;
    private boolean z;
    private boolean A;
    private boolean B;
    private String C;
    private int D;
    private int E = 0;
    private long F;
    private long G;
    private long H;
    private long I;
    public final long[] f = new long[100];
    public final long[] g = new long[100];
    public final long[] h = new long[100];
    public final long[] i = new long[100];
    public final long[] j = new long[100];
    public long[][] k;
    private KeyPair J;
    private String K;
    private String L;
    private String M;
    private boolean N;
    private boolean O;
    private boolean P;
    private String Q = "";
    private boolean R;
    private long S;
    private String T;
    private boolean U;
    private boolean V;
    public int default_world_map_size = 1024;
    public boolean save_world_maps_on_shutdown;
    public int ms_taken_for_last_100_ticks;
    public static boolean treachery_detected;
    private static int treachery_shutdown_counter;
    public static final int num_world_servers = 4;
    public final hi thread;
    public static final int WORLD_INDEX_OVERWORLD = 0;
    public static final int WORLD_INDEX_NETHER = 1;
    public static final int WORLD_INDEX_THE_END = 2;
    public static final int WORLD_INDEX_UNDERWORLD = 3;

    public MinecraftServer(File par1File) {
        l = this;
        this.o = par1File;
        this.q = new il();
        this.m = new aln(par1File);
        this.as();
        if (atv.hit_list == null) {
            atv.hit_list = atv.getHitList();
        }
        atv.server_thread = this.thread = new hi(this, "Server thread");
    }

    private void as() {
        gq.a();
    }

    protected abstract boolean d() throws IOException;

    protected void a(String par1Str) {
        if (this.P().b(par1Str)) {
            this.an().a("Converting map!");
            this.b("menu.convertingLevel");
            this.P().a(par1Str, new hg(this));
        }
    }

    protected synchronized void b(String par1Str) {
        this.T = par1Str;
    }

    public synchronized String e() {
        return this.T;
    }

    protected void a(String par1Str, String par2Str, long par3, acg par5WorldType, String par6Str) {
        acd var8;
        this.a(par1Str);
        this.b("menu.loadingLevel");
        this.b = new js[4];
        this.k = new long[this.b.length][100];
        amc var7 = this.m.a(par1Str, true);
        als var9 = var7.d();
        if (var9 == null) {
            var8 = new acd(par3, this.h(), this.g(), this.j(), par5WorldType, this.areSkillsEnabled());
            var8.a(par6Str);
        } else {
            var8 = new acd(var9);
        }
        if (this.O) {
            var8.a();
        }
        for (int var10 = 0; var10 < this.b.length; ++var10) {
            byte var11 = (byte)MinecraftServer.getWorldDimensionIdFromIndex(var10);
            this.b[var10] = var10 == 0 ? (this.O() ? new jj(this, var7, par2Str, var11, this.a, this.an()) : new js(this, var7, par2Str, var11, var8, this.a, this.an())) : new jl(this, var7, par2Str, var11, var8, this.b[0], this.a, this.an());
            this.b[var10].a(new jo(this, this.b[var10]));
            if (!this.K()) {
                this.b[var10].N().a(this.h());
            }
            this.t.a(this.b);
        }
        this.c(this.i());
        this.f();
    }

    protected void f() {
        boolean var1 = true;
        boolean var2 = true;
        boolean var3 = true;
        boolean var4 = true;
        int var5 = 0;
        this.b("menu.generatingTerrain");
        int var6 = 0;
        this.an().a("Preparing start region for level " + var6);
        js var7 = this.b[var6];
        t var8 = var7.K();
        long var9 = MinecraftServer.aq();
        for (int var11 = -192; var11 <= 192 && this.o(); var11 += 16) {
            for (int var12 = -192; var12 <= 192 && this.o(); var12 += 16) {
                long var13 = MinecraftServer.aq();
                if (var13 - var9 > 1000L) {
                    this.a_("Preparing spawn area", var5 * 100 / 625);
                    var9 = var13;
                }
                ++var5;
                var7.b.c(var8.a + var11 >> 4, var8.c + var12 >> 4);
            }
        }
        this.l();
    }

    public abstract boolean g();

    public abstract ace h();

    public abstract int i();

    public abstract boolean j();

    public abstract int k();

    public abstract boolean areSkillsEnabled();

    protected void a_(String par1Str, int par2) {
        this.d = par1Str;
        this.e = par2;
        this.an().a(par1Str + ": " + par2 + "%");
    }

    protected void l() {
        this.d = null;
        this.e = 0;
    }

    protected void saveAllWorlds(boolean par1, boolean wait_until_finished) {
        if (treachery_detected) {
            return;
        }
        if (!this.P) {
            for (js var5 : this.b) {
                if (var5 == null) continue;
                try {
                    var5.a(true, (lx)null);
                }
                catch (aca var7) {
                    this.an().b(var7.getMessage());
                }
            }
            if (wait_until_finished) {
                ams.a();
            }
        }
    }

    public void m() {
        if (!this.P) {
            this.an().a("Stopping server");
            if (this.ag() != null) {
                this.ag().a();
            }
            if (this.t != null) {
                if (!treachery_detected) {
                    this.an().a("Saving players");
                    this.t.g();
                }
                this.t.r();
            }
            if (!treachery_detected) {
                this.an().a("Saving worlds");
                long t2 = System.currentTimeMillis();
                this.saveAllWorlds(false, true);
                this.an().a("Finished saving all worlds in " + StringHelper.formatFloat((float)(System.currentTimeMillis() - t2) / 1000.0f) + " seconds");
                if (is.tournament_type == EnumTournamentType.score) {
                    is.appendTournamentStandingsToFile(true);
                }
                if (this.save_world_maps_on_shutdown) {
                    this.saveWorldMaps();
                } else {
                    this.an().a("Discarding world maps");
                }
            }
            if (treachery_detected) {
                MinecraftServer.clearTreacheryDetected();
            }
            for (int var1 = 0; var1 < this.b.length; ++var1) {
                js var2 = this.b[var1];
                var2.n();
            }
            if (this.n != null && this.n.d()) {
                this.n.e();
            }
            this.finalCleanup();
        } else if (treachery_detected) {
            MinecraftServer.clearTreacheryDetected();
        }
    }

    private void finalCleanup() {
        boolean display_amount_freed = false;
        long free_memory = 0L;
        if (display_amount_freed) {
            System.gc();
            free_memory = Runtime.getRuntime().freeMemory();
        }
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.b[i2].finalCleanup();
        }
        if (display_amount_freed) {
            System.gc();
            Debug.println("finalCleanup: " + (Runtime.getRuntime().freeMemory() - free_memory) / 1024L / 1024L + " MB of memory was freed");
        }
    }

    public String n() {
        return this.r;
    }

    public void c(String par1Str) {
        this.r = par1Str;
    }

    public boolean o() {
        return this.u;
    }

    public void p() {
        this.u = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.d()) {
                long var1 = MinecraftServer.aq();
                long var50 = 0L;
                while (this.u) {
                    long var5 = MinecraftServer.aq();
                    long var7 = var5 - var1;
                    if (var7 > 2000L && var1 - this.S >= 15000L) {
                        this.an().b("Can't keep up! Did the system time change, or is the server overloaded?");
                        var7 = 2000L;
                        this.S = var1;
                    }
                    if (var7 < 0L) {
                        this.an().b("Time ran backwards! Did the system time change?");
                        var7 = 0L;
                    }
                    var50 += var7;
                    var1 = var5;
                    if (this.b[0].allPlayersAsleepOrDead()) {
                        this.s();
                        var50 = 0L;
                    } else {
                        while (var50 > 50L) {
                            var50 -= 50L;
                            this.s();
                        }
                    }
                    Thread.sleep(1L);
                    this.R = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable var48) {
            var48.printStackTrace();
            this.an().c("Encountered an unexpected exception " + var48.getClass().getSimpleName(), var48);
            b var2 = null;
            var2 = var48 instanceof u ? this.b(((u)var48).a()) : this.b(new b("Exception in server tick loop", var48));
            File var3 = new File(new File(this.q(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (var2.a(var3, this.an())) {
                this.an().c("This crash report has been saved to: " + var3.getAbsolutePath());
            } else {
                this.an().c("We were unable to save this crash report to disk.");
            }
            this.a(var2);
        }
        finally {
            try {
                this.save_world_maps_on_shutdown = this.isServerSideMappingEnabled();
                this.m();
                this.v = true;
            }
            catch (Throwable var46) {
                var46.printStackTrace();
            }
            finally {
                this.r();
            }
        }
    }

    protected File q() {
        return new File(".");
    }

    protected void a(b par1CrashReport) {
    }

    protected void r() {
    }

    public void s() {
        if (treachery_detected) {
            if (treachery_shutdown_counter == 200) {
                this.t.a(cv.d(this.scramble("Givzxsvib wvgvxgvw! Tznv droo hsfg wldm rm 89 hvxlmwh.")).a(a.o));
            }
            if (--treachery_shutdown_counter <= 0) {
                this.p();
            }
        }
        if (!this.V() && this.w % 20 == 0) {
            bjo.verifyResourceLocations();
        }
        long system_ms_at_beginning_of_tick = System.currentTimeMillis();
        StringBuilder sb2 = new StringBuilder();
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            sb2.append(this.b[i2].V().c());
            if (i2 >= this.b.length - 1) continue;
            sb2.append(" | ");
        }
        atv.server_pools_string = sb2.toString();
        long var1 = System.nanoTime();
        asx.a().a();
        ++this.w;
        if (this.U) {
            this.U = false;
            this.a.a = true;
            this.a.a();
        }
        this.a.a("root");
        this.t();
        if (!treachery_detected && this.w % 900 == 0) {
            boolean abort = false;
            for (int i3 = 0; i3 < this.b.length; ++i3) {
                if (this.b[i3] == null || !this.b[i3].hasScheduledBlockChanges()) continue;
                abort = true;
                break;
            }
            if (!abort) {
                this.a.a("save");
                this.t.g();
                this.saveAllWorlds(true, false);
                this.a.b();
            }
        }
        this.a.a("tallying");
        this.j[this.w % 100] = System.nanoTime() - var1;
        this.f[this.w % 100] = ey.q - this.F;
        this.F = ey.q;
        this.g[this.w % 100] = ey.r - this.G;
        this.G = ey.r;
        this.h[this.w % 100] = ey.o - this.H;
        this.H = ey.o;
        this.i[this.w % 100] = ey.p - this.I;
        this.I = ey.p;
        this.a.b();
        this.a.a("snooper");
        if (!this.n.d() && this.w > 100) {
            this.n.a();
        }
        if (this.w % 6000 == 0) {
            this.n.b();
        }
        this.a.b();
        this.a.b();
        this.ms_taken_for_last_100_ticks = (int)((long)this.ms_taken_for_last_100_ticks + (System.currentTimeMillis() - system_ms_at_beginning_of_tick));
        if (this.w >= 100) {
            int avg_ms_per_tick = this.getAverageTickTime();
            this.ms_taken_for_last_100_ticks -= avg_ms_per_tick;
            if (this.w % 20 == 0 && this.getLoadOnServer() >= 1.0f) {
                this.t.a(new Packet85SimpleSignal(EnumSignal.cpu_overburdened));
            }
        }
        if (DebugAttack.instance != null) {
            DebugAttack.flush();
        }
    }

    public int getAverageTickTime() {
        return this.ms_taken_for_last_100_ticks / 100;
    }

    public float getLoadOnServer() {
        return this.w < 100 ? -1.0f : (float)this.ms_taken_for_last_100_ticks / 5000.0f;
    }

    public void sendWorldAgesToAllClientsInAllDimensions() {
        if (Packet92UpdateTimeSmall.areAllWorldTotalTimesSuitable(this.b)) {
            this.t.a(new Packet92UpdateTimeSmall(this));
        } else {
            this.t.a(new fx(this));
        }
    }

    public void sendWorldAgesToClient(jv player) {
        if (Packet92UpdateTimeSmall.areAllWorldTotalTimesSuitable(this.b)) {
            player.sendPacket(new Packet92UpdateTimeSmall(this));
        } else {
            player.sendPacket(new fx(this));
        }
    }

    public void t() {
        int var1;
        this.a.a("levels");
        if (this.w % 20 == 0) {
            this.sendWorldAgesToAllClientsInAllDimensions();
        }
        for (var1 = 0; var1 < this.b.length; ++var1) {
            long var2 = System.nanoTime();
            if (var1 == 0 || this.u()) {
                js var4 = this.b[var1];
                this.a.a(var4.N().k());
                this.a.a("pools");
                var4.V().a();
                this.a.b();
                this.a.a("timeSync");
                this.a.b();
                this.a.a("tick");
                try {
                    var4.b();
                }
                catch (Throwable var8) {
                    b var6 = b.a(var8, "Exception ticking world");
                    var4.a(var6);
                    throw new u(var6);
                }
                try {
                    var4.h();
                }
                catch (Throwable var7) {
                    b var6 = b.a(var7, "Exception ticking world entities");
                    var4.a(var6);
                    throw new u(var6);
                }
                this.a.b();
                this.a.a("tracker");
                var4.q().a();
                this.a.b();
                this.a.b();
            }
            this.k[var1][this.w % 100] = System.nanoTime() - var2;
        }
        this.a.c("connection");
        this.ag().b();
        this.a.c("players");
        this.t.sendPlayerInfoToAllPlayers(false);
        this.a.c("tickables");
        for (var1 = 0; var1 < this.p.size(); ++var1) {
            ((hr)this.p.get(var1)).a();
        }
        this.a.b();
    }

    public boolean u() {
        return true;
    }

    public void func_82010_a(hr par1IUpdatePlayerListBox) {
        this.playersOnline.add(par1IUpdatePlayerListBox);
    }

    public static void main(String[] par0ArrayOfStr) {
        if (atv.java_version_is_outdated) {
            System.out.println("Minecraft Is Too Easy requires Java 1.7 or later!");
            return;
        }
        la.a();
        lp var1 = null;
        try {
            boolean var2 = !GraphicsEnvironment.isHeadless();
            String var3 = null;
            String var4 = ".";
            String var5 = null;
            boolean var6 = false;
            boolean var7 = false;
            int var8 = -1;
            for (int var9 = 0; var9 < par0ArrayOfStr.length; ++var9) {
                String var10 = par0ArrayOfStr[var9];
                String var11 = var9 == par0ArrayOfStr.length - 1 ? null : par0ArrayOfStr[var9 + 1];
                boolean var12 = false;
                if (!var10.equals("nogui") && !var10.equals("--nogui")) {
                    if (var10.equals("--port") && var11 != null) {
                        var12 = true;
                        try {
                            var8 = Integer.parseInt(var11);
                        }
                        catch (NumberFormatException var14) {}
                    } else if (var10.equals("--singleplayer") && var11 != null) {
                        var12 = true;
                        var3 = var11;
                    } else if (var10.equals("--universe") && var11 != null) {
                        var12 = true;
                        var4 = var11;
                    } else if (var10.equals("--world") && var11 != null) {
                        var12 = true;
                        var5 = var11;
                    } else if (var10.equals("--demo")) {
                        var6 = true;
                    } else if (var10.equals("--bonusChest")) {
                        var7 = true;
                    }
                } else {
                    var2 = false;
                }
                if (!var12) continue;
                ++var9;
            }
            is var16 = new is(new File(var4));
            var1 = var16.an();
            if (var3 != null) {
                var16.j(var3);
            }
            if (var5 != null) {
                var16.k(var5);
            }
            if (var8 >= 0) {
                var16.b(var8);
            }
            if (var6) {
                var16.b(true);
            }
            if (var7) {
                var16.c(true);
            }
            if (var2) {
                var16.func_120011_ar();
            }
            var16.v();
            Runtime.getRuntime().addShutdownHook(new ThreadDedicatedServer(var16));
        }
        catch (Exception var15) {
            if (var1 != null) {
                var1.c("Failed to start the minecraft server", var15);
            }
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failed to start the minecraft server", var15);
        }
    }

    public void v() {
        this.thread.start();
    }

    public File d(String par1Str) {
        return new File(this.q(), par1Str);
    }

    public void e(String par1Str) {
        this.an().a(par1Str);
    }

    public void f(String par1Str) {
        this.an().b(par1Str);
    }

    public js a(int par1) {
        return this.b[MinecraftServer.getWorldIndexForDimensionId(par1)];
    }

    public String w() {
        return this.r;
    }

    public int x() {
        return this.s;
    }

    public String y() {
        return this.ac();
    }

    public String z() {
        return "1.6.4";
    }

    public int A() {
        return this.t.k();
    }

    public int B() {
        return this.t.l();
    }

    public String[] C() {
        return this.t.d();
    }

    public String D() {
        return "";
    }

    public String executeCommand(String par1Str, boolean permission_override) {
        kh.a.d();
        this.q.executeCommand(kh.a, par1Str, permission_override);
        return kh.a.e();
    }

    public boolean E() {
        return false;
    }

    public void h(String par1Str) {
        this.an().c(par1Str);
    }

    public void i(String par1Str) {
        if (this.E()) {
            this.an().a(par1Str);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b par1CrashReport) {
        par1CrashReport.g().a("Profiler Position", new hj(this));
        if (this.b != null && this.b.length > 0 && this.b[0] != null) {
            par1CrashReport.g().a("Vec3 Pool Size", new hk(this));
        }
        if (this.t != null) {
            par1CrashReport.g().a("Player Count", new hl(this));
        }
        return par1CrashReport;
    }

    public List a(ad par1ICommandSender, String par2Str) {
        ArrayList<String> var3 = new ArrayList<String>();
        if (par2Str.startsWith("/")) {
            boolean var10 = !(par2Str = par2Str.substring(1)).contains(" ");
            List var11 = this.q.b(par1ICommandSender, par2Str);
            if (var11 != null) {
                for (String var13 : var11) {
                    if (var10) {
                        var3.add("/" + var13);
                        continue;
                    }
                    var3.add(var13);
                }
            }
            return var3;
        }
        String[] var4 = par2Str.split(" ", -1);
        String var5 = var4[var4.length - 1];
        for (String var9 : this.t.d()) {
            if (!z.a(var5, var9)) continue;
            var3.add(var9);
        }
        return var3;
    }

    public static MinecraftServer F() {
        return l;
    }

    @Override
    public String c_() {
        return "Server";
    }

    @Override
    public void a(cv par1ChatMessageComponent) {
        this.an().a(par1ChatMessageComponent.toString());
    }

    @Override
    public boolean a(int par1, String par2Str) {
        return true;
    }

    public ac G() {
        return this.q;
    }

    public KeyPair H() {
        return this.J;
    }

    public int I() {
        return this.s;
    }

    public void b(int par1) {
        this.s = par1;
    }

    public String J() {
        return this.K;
    }

    public void j(String par1Str) {
        this.K = par1Str;
    }

    public boolean K() {
        return this.K != null;
    }

    public String L() {
        return this.L;
    }

    public void k(String par1Str) {
        this.L = par1Str;
    }

    public void l(String par1Str) {
        this.M = par1Str;
    }

    public String M() {
        return this.M;
    }

    public void a(KeyPair par1KeyPair) {
        this.J = par1KeyPair;
    }

    public void c(int par1) {
        for (int var2 = 0; var2 < this.b.length; ++var2) {
            js var3 = this.b[var2];
            if (var3 == null) continue;
            var3.r = 3;
            var3.a(true, true);
        }
    }

    protected boolean N() {
        return true;
    }

    public boolean O() {
        return this.N;
    }

    public void b(boolean par1) {
        this.N = par1;
    }

    public void c(boolean par1) {
        this.O = par1;
    }

    public amf P() {
        return this.m;
    }

    public void R() {
        this.P = true;
        this.P().d();
        for (int var1 = 0; var1 < this.b.length; ++var1) {
            js var2 = this.b[var1];
            if (var2 == null) continue;
            var2.n();
        }
        this.P().e(this.b[0].M().g());
        this.p();
    }

    public String S() {
        return this.Q;
    }

    public void m(String par1Str) {
        this.Q = par1Str;
    }

    @Override
    public void a(mv par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.a("whitelist_enabled", false);
        par1PlayerUsageSnooper.a("whitelist_count", 0);
        par1PlayerUsageSnooper.a("players_current", this.A());
        par1PlayerUsageSnooper.a("players_max", this.B());
        par1PlayerUsageSnooper.a("players_seen", this.t.m().length);
        par1PlayerUsageSnooper.a("uses_auth", this.x);
        par1PlayerUsageSnooper.a("gui_state", this.ai() ? "enabled" : "disabled");
        par1PlayerUsageSnooper.a("run_time", (MinecraftServer.aq() - par1PlayerUsageSnooper.g()) / 60L * 1000L);
        par1PlayerUsageSnooper.a("avg_tick_ms", (int)(ls.a(this.j) * 1.0E-6));
        par1PlayerUsageSnooper.a("avg_sent_packet_count", (int)ls.a(this.f));
        par1PlayerUsageSnooper.a("avg_sent_packet_size", (int)ls.a(this.g));
        par1PlayerUsageSnooper.a("avg_rec_packet_count", (int)ls.a(this.h));
        par1PlayerUsageSnooper.a("avg_rec_packet_size", (int)ls.a(this.i));
        int var2 = 0;
        for (int var3 = 0; var3 < this.b.length; ++var3) {
            if (this.b[var3] == null) continue;
            js var4 = this.b[var3];
            als var5 = var4.N();
            par1PlayerUsageSnooper.a("world[" + var2 + "][dimension]", var4.t.i);
            par1PlayerUsageSnooper.a("world[" + var2 + "][mode]", (Object)var5.r());
            par1PlayerUsageSnooper.a("world[" + var2 + "][difficulty]", var4.r);
            par1PlayerUsageSnooper.a("world[" + var2 + "][hardcore]", var5.t());
            par1PlayerUsageSnooper.a("world[" + var2 + "][generator_name]", var5.u().a());
            par1PlayerUsageSnooper.a("world[" + var2 + "][generator_version]", var5.u().c());
            par1PlayerUsageSnooper.a("world[" + var2 + "][height]", this.D);
            par1PlayerUsageSnooper.a("world[" + var2 + "][chunks_loaded]", var4.L().f());
            ++var2;
        }
        par1PlayerUsageSnooper.a("worlds", var2);
    }

    @Override
    public void b(mv par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.a("singleplayer", this.K());
        par1PlayerUsageSnooper.a("server_brand", this.getServerModName());
        par1PlayerUsageSnooper.a("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        par1PlayerUsageSnooper.a("dedicated", this.V());
    }

    @Override
    public boolean T() {
        return true;
    }

    public int U() {
        return 16;
    }

    public abstract boolean V();

    public boolean W() {
        return this.x;
    }

    public void d(boolean par1) {
        this.x = par1;
    }

    public boolean X() {
        return this.y;
    }

    public void e(boolean par1) {
        this.y = par1;
    }

    public boolean Y() {
        return this.z;
    }

    public void f(boolean par1) {
        this.z = par1;
    }

    public boolean Z() {
        return this.A;
    }

    public void g(boolean par1) {
        this.A = par1;
    }

    public boolean aa() {
        return this.B;
    }

    public void h(boolean par1) {
        this.B = par1;
    }

    public abstract boolean ab();

    public String ac() {
        if (atv.isInTournamentMode()) {
            return "1.6.4-MITE Tournament Server " + this.f_().getHourOfDayAMPM();
        }
        if (l.V()) {
            return this.C + " (" + this.f_().getHourOfDayAMPM() + ")";
        }
        return this.C;
    }

    public void n(String par1Str) {
        this.C = par1Str;
    }

    public int ad() {
        return this.D;
    }

    public void d(int par1) {
        this.D = par1;
    }

    public boolean ae() {
        return this.v;
    }

    public hn af() {
        return this.t;
    }

    public void a(hn par1ServerConfigurationManager) {
        this.t = par1ServerConfigurationManager;
    }

    public void a(ace par1EnumGameType) {
        for (int var2 = 0; var2 < this.b.length; ++var2) {
            MinecraftServer.F().b[var2].N().a(par1EnumGameType);
        }
    }

    public abstract kd ag();

    public boolean ah() {
        return this.R;
    }

    public boolean ai() {
        return false;
    }

    public abstract String a(ace var1, boolean var2);

    public int aj() {
        return this.w;
    }

    public void ak() {
        this.U = true;
    }

    public mv al() {
        return this.n;
    }

    @Override
    public t b() {
        return new t(0, 0, 0);
    }

    @Override
    public abw f_() {
        return this.b[0];
    }

    public int am() {
        return 16;
    }

    public boolean a(abw par1World, int par2, int par3, int par4, uf par5EntityPlayer) {
        return false;
    }

    @Override
    public abstract lp an();

    public abstract lp getAuxLogAgent();

    public void i(boolean par1) {
        this.V = par1;
    }

    public boolean ao() {
        return this.V;
    }

    public Proxy ap() {
        return this.c;
    }

    public static long aq() {
        return System.currentTimeMillis();
    }

    public int ar() {
        return this.E;
    }

    public void e(int par1) {
        this.E = par1;
    }

    public static hn a(MinecraftServer par0MinecraftServer) {
        return par0MinecraftServer.t;
    }

    public static void sendPacketToAllPlayersOnServer(ey packet) {
        for (jv player : MinecraftServer.l.af().a) {
            player.a.b(packet);
        }
    }

    public void playerLoggedIn(jv par1EntityPlayerMP) {
    }

    public void playerLoggedOut(jv par1EntityPlayerMP) {
    }

    public abstract boolean isServerSideMappingEnabled();

    public void saveWorldMaps() {
        if (treachery_detected) {
            return;
        }
        this.an().a("Saving world maps...");
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            js world = this.b[i2];
            if (world.world_map == null) continue;
            world.world_map.writeToFile();
        }
        this.an().a("Finished saving world maps");
    }

    public static void setTreacheryDetected() {
        if (treachery_detected) {
            return;
        }
        treachery_detected = true;
        if (treachery_shutdown_counter == 0) {
            treachery_shutdown_counter = 400;
        }
    }

    public static void clearTreacheryDetected() {
        treachery_detected = false;
        treachery_shutdown_counter = 0;
    }

    public static boolean isPlayerHostingGame(uf player) {
        if (atv.O == null || atv.O.h == null) {
            return false;
        }
        return atv.O.h == player || atv.O.h.k == player.k;
    }

    public boolean isZevimrgvOnServer() {
        return this.af().isZevimrgvOnServer();
    }

    public void addTotalTimeForAllWorlds(int time_to_add) {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            js world = this.b[i2];
            long new_total_time = world.I() + (long)time_to_add;
            if (new_total_time < 0L) {
                new_total_time = 0L;
            }
            int new_time_of_day = (int)(new_total_time % 24000L);
            world.setTotalWorldTime(new_total_time);
        }
        this.sendWorldAgesToAllClientsInAllDimensions();
    }

    public String scramble(String s2) {
        char[] chars = s2.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            int c2 = chars[i2];
            if (c2 >= 65 && c2 <= 90) {
                c2 = 90 - (c2 - 65);
            } else if (c2 >= 97 && c2 <= 122) {
                c2 = 122 - (c2 - 97);
            } else if (c2 >= 48 && c2 <= 57) {
                c2 = 57 - (c2 - 48);
            }
            chars[i2] = (char)c2;
        }
        return new String(chars);
    }

    public final boolean hasPlayers(boolean must_be_alive, boolean must_not_be_ghosts) {
        for (jv player : this.af().a) {
            if (must_be_alive && player.aN() <= 0.0f || must_not_be_ghosts && (player.isGhost() || player.isZevimrgvInTournament())) continue;
            return true;
        }
        return false;
    }

    public final boolean hasNoPlayersOfAnyKindConnected() {
        return this.af().a.isEmpty();
    }

    public final boolean hasPlayersOfAnyKindConnected() {
        return !this.hasNoPlayersOfAnyKindConnected();
    }

    public final boolean hasNonGhostPlayersConnected(boolean must_be_alive) {
        return this.hasPlayers(must_be_alive, true);
    }

    public final boolean hasOnlyGhostPlayersConnected() {
        return this.hasPlayersOfAnyKindConnected() && !this.hasNonGhostPlayersConnected(false);
    }

    public final boolean hasOnlyGhostsOrDeadPlayersConnected() {
        return this.hasPlayersOfAnyKindConnected() && !this.hasNonGhostPlayersConnected(true);
    }

    public final js getOverworld() {
        return this.b[0];
    }

    public final js getUnderworld() {
        return this.b[3];
    }

    public final js getNether() {
        return this.b[1];
    }

    public final js getTheEnd() {
        return this.b[2];
    }

    public final int getVillageConditions() {
        return this.getOverworld().N().getVillageConditions();
    }

    public static int getWorldIndexForDimensionId(int dimension_id) {
        if (dimension_id == 0) {
            return 0;
        }
        if (dimension_id == -2) {
            return 3;
        }
        if (dimension_id == -1) {
            return 1;
        }
        if (dimension_id == 1) {
            return 2;
        }
        atv.setErrorMessage("getWorldIndexForDimensionId: unable to map dimension id " + dimension_id + " to a world index");
        return 0;
    }

    public static int getWorldDimensionIdFromIndex(int index) {
        if (index == 0) {
            return 0;
        }
        if (index == 3) {
            return -2;
        }
        if (index == 1) {
            return -1;
        }
        if (index == 2) {
            return 1;
        }
        atv.setErrorMessage("getWorldDimensionIdFromIndex: unable to map index " + index + " to a dimension id");
        return 0;
    }

    static {
        bim.unloadTextures();
        nn.resetEntityIds();
    }
}

